/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.util;

import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.servlet.activity.ActivityManager;
import com.ibm.hwmca.fw.servlet.login.AutoLogonManager;
import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.taskcontroller.TaskControllerListener;
import com.ibm.hwmca.fw.servlet.taskcontroller.TaskControllerQueue;
import com.ibm.hwmca.fw.servlet.util.HMCCustomScope;
import com.ibm.hwmca.fw.servlet.util.HMCSessionLifeListener;
import com.ibm.hwmca.fw.servlet.util.HMCSessionListener;
import com.ibm.hwmca.fw.servlet.util.HMCSessionWindowListener;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.ui.UIStyle;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;

public class HMCSession {
    private static final String TRACE_MASKT = "XTIFSEST";
    private static final String TRACE_MASKF = "XTIFSESF";
    private static final String HMCSESSION_ATTRIBUTE_IN_HTTP_SESSION = "util.hmcsession";
    private static final String HMCSESSION_NAME_ATTRIBUTE_IN_HTTP_SESSION = "hmcsession";
    private static final String PROCESSING_RECONNECT_ATTRIBUTE_IN_HTTP_SESSION = "util.reconnect.processing";
    private static final String RECOGNITION_TOKEN_ATTRIBUTE_IN_HTTP_SESSION = "util.recognition.token";
    private static final String REAP_TIME_ATTRIBUTE_IN_PORTAL = "util.hmcsession.reapTime";
    private static final int ZOMBIE_WAIT_TIME = 90000;
    private static long sessionIdSequence;
    private static List allSessions;
    private static List allDisconnectedSessions;
    private static List sessionLifeListeners;
    private static AutoLogonManager.AutoLogonInterface autoLogonInterface;
    private Map contextAttributes = new HashMap();
    private Map sessionAttributes = new HashMap();
    private HttpSession httpSession;
    private String sessionId;
    private HMCCustomScope wclScopeObject;
    private Date creationTime;
    private Date connectionTime;
    private Date disconnectionTime;
    private Date lossOfConnectivityTime;
    private Date lastUserActivityTime;
    private Date userClosedMainUIWindowTime;
    private int disconnectionReason;
    private ClientUserContext userContext;
    private Listener listener;
    private Map taskIdToPanelPortals = new HashMap();
    private List endedTasks = new ArrayList(5);
    private List sessionListeners = new ArrayList(5);
    private List windowListeners;
    private Object windowListenersLock = new Object();
    public static final int DISCONNECT_NOT_DISCONNECTED = 0;
    public static final int DISCONNECT_BY_USER = 1;
    public static final int DISCONNECT_BY_ANOTHER_USER = 2;
    public static final int DISCONNECT_DUE_TO_IDLENESS = 3;
    public static final int DISCONNECT_LOSS_OF_CONNECTIVITY = 4;
    public static final int DISCONNECT_DIDNT_REAUTHENTICATE_IN_TIME = 5;
    public static final int DISCONNECT_REAUTHENTICATION_FAILED = 6;
    public static final int DISCONNECT_LOGGING_OFF = 7;
    public static final int DISCONNECT_LOGOFF_BY_ANOTHER_USER = 8;
    public static final int DISCONNECT_BY_PROXY = 9;

    private HMCSession(HttpSession httpSession) {
        this.sessionId = HMCSession.assignName();
        this.lossOfConnectivityTime = this.creationTime = new Date();
        Trace.trace(TRACE_MASKT, "Creating new HMCSession with id " + this.sessionId);
        this.wclScopeObject = new HMCCustomScope(this.sessionId);
        this.setContextAttribute(this.sessionId, this.wclScopeObject);
        HMCSession.addSession(this);
        this.connectToWebSession(httpSession);
        this.listener = new Listener();
        TaskControllerQueue.getTaskControllerQueue(this).addTaskControllerListener(this.listener);
    }

    public static HMCSession getHMCSession(HttpSession httpSession) {
        return HMCSession.getHMCSession(httpSession, true);
    }

    public static synchronized HMCSession getHMCSession(HttpSession httpSession, boolean create) {
        HMCSession hmcSession = (HMCSession)httpSession.getAttribute(HMCSESSION_ATTRIBUTE_IN_HTTP_SESSION);
        if (hmcSession == null && create) {
            if (httpSession.getAttribute("util.defunctSession") != null) {
                throw new IllegalStateException("Can't create new HMCSession from defunct HttpSession");
            }
            hmcSession = new HMCSession(httpSession);
        }
        return hmcSession;
    }

    public static synchronized HMCSession getHMCSession(String sessionId) {
        Iterator iterator = allSessions.iterator();
        while (iterator.hasNext()) {
            HMCSession session = (HMCSession)iterator.next();
            if (!session.getSessionId().equals(sessionId)) continue;
            return session;
        }
        return null;
    }

    private static synchronized String assignName() {
        return "util.hmcsession." + Long.toString(++sessionIdSequence);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getDisplayableSessionId() {
        return this.sessionId.substring(this.sessionId.lastIndexOf(46) + 1);
    }

    public String getWindowPrefix() {
        return HMC.getTitle() + "_" + this.getDisplayableSessionId() + "_";
    }

    public synchronized void connectToWebSession(HttpSession httpSession) throws IllegalStateException {
        HMCSession hmcSession = (HMCSession)httpSession.getAttribute(HMCSESSION_ATTRIBUTE_IN_HTTP_SESSION);
        if (hmcSession != null) {
            throw new IllegalStateException("The HTTP session is already connected to an HMC session");
        }
        if (this.httpSession != null) {
            throw new IllegalStateException("The HMC session is already connected to an HTTP session");
        }
        Trace.trace(TRACE_MASKT, "Connecting HMCSession with id " + this.sessionId + " to HTTP session with id " + httpSession.getId());
        this.httpSession = httpSession;
        httpSession.setAttribute(HMCSESSION_ATTRIBUTE_IN_HTTP_SESSION, (Object)this);
        httpSession.setAttribute(HMCSESSION_NAME_ATTRIBUTE_IN_HTTP_SESSION, (Object)this.sessionId);
        httpSession.removeAttribute("util.hmcSessionId");
        httpSession.removeAttribute("util.defunctWindowNames");
        httpSession.removeAttribute("util.defunctSession");
        httpSession.removeAttribute("util.defunctReasonCode");
        httpSession.removeAttribute("util.defunctSessionMessage");
        httpSession.setMaxInactiveInterval(-1);
        this.connectionTime = new Date();
        this.disconnectionTime = null;
        this.lastUserActivityTime = this.connectionTime;
        this.lossOfConnectivityTime = null;
        this.copyAttributesToServletContext();
        this.fireSessionConnectedEvent();
        HMCSession.removeDisconnectedSession(this);
        this.notifyAssociatingWithHMCSession(httpSession);
    }

    private synchronized void copyAttributesToServletContext() {
        ServletContext context = this.httpSession.getServletContext();
        Iterator iterator = this.contextAttributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            context.setAttribute((String)entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectFromWebSession(int reason, boolean launchBrowserCleanup) throws IllegalStateException {
        HttpSession httpSessionToCleanup = null;
        HMCSession hMCSession = this;
        synchronized (hMCSession) {
            if (this.httpSession != null && launchBrowserCleanup && this.haveConnectivity()) {
                httpSessionToCleanup = this.httpSession;
            }
        }
        this.disconnectFromWebSession(reason);
        if (httpSessionToCleanup != null) {
            ActivityManager.getActivityManager().launchDisconnectCleanup(this, httpSessionToCleanup);
        }
    }

    public synchronized void disconnectFromWebSession(int reason) throws IllegalStateException {
        if (this.httpSession == null) {
            throw new IllegalStateException("The HMC session is already disconnected");
        }
        this.disconnectionReason = reason;
        Trace.trace(TRACE_MASKT, "Disconnecting HMCSession with id " + this.sessionId + " from HTTP session with id " + this.httpSession.getId() + " for reason code " + this.disconnectionReason);
        this.markHttpSessionDefunct();
        this.httpSession.setAttribute("util.defunctReasonCode", (Object)new Integer(reason));
        this.httpSession.removeAttribute(HMCSESSION_ATTRIBUTE_IN_HTTP_SESSION);
        this.httpSession.removeAttribute(HMCSESSION_NAME_ATTRIBUTE_IN_HTTP_SESSION);
        this.disconnectionTime = new Date();
        this.connectionTime = null;
        this.httpSession.setAttribute("util.disconnectTime", (Object)this.disconnectionTime);
        HttpSession previousHttpSession = this.httpSession;
        this.httpSession = null;
        this.fireSessionDisconnectedEvent();
        HMCSession.addDisconnectedSession(this);
        this.notifyDisassociatingFromHMCSession(previousHttpSession);
    }

    public boolean isDisconnected() {
        return this.httpSession == null;
    }

    private static synchronized void addDisconnectedSession(HMCSession hmcSession) {
        if (allDisconnectedSessions == null) {
            allDisconnectedSessions = new ArrayList();
        }
        allDisconnectedSessions.add(hmcSession);
    }

    private static synchronized void removeDisconnectedSession(HMCSession hmcSession) {
        if (allDisconnectedSessions == null) {
            return;
        }
        allDisconnectedSessions.remove(hmcSession);
    }

    private static synchronized void addSession(HMCSession hmcSession) {
        allSessions.add(hmcSession);
        HMCSession.fireSessionCreatedEvent(hmcSession);
    }

    private static synchronized void removeSession(HMCSession hmcSession) {
        allSessions.remove(hmcSession);
        HMCSession.fireSessionRemovedEvent(hmcSession);
    }

    public ClientUserContext getUserContext() {
        return this.userContext;
    }

    public void setUserContext(ClientUserContext userContext) {
        this.userContext = userContext;
    }

    public static synchronized Collection getAllSessions() {
        return new ArrayList(allSessions);
    }

    public static synchronized Collection getDisconnectedSessions(String user) {
        if (allDisconnectedSessions == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<HMCSession> result = new ArrayList<HMCSession>();
        Iterator iterator = allDisconnectedSessions.iterator();
        while (iterator.hasNext()) {
            HMCSession hmcSession = (HMCSession)iterator.next();
            ClientUserContext uContext = hmcSession.getUserContext();
            if (uContext == null || !uContext.getUserName().equals(user)) continue;
            result.add(hmcSession);
        }
        return result;
    }

    public synchronized void addHMCSessionListener(HMCSessionListener listener) {
        this.sessionListeners.add(listener);
    }

    public synchronized void removeHMCSessionListener(HMCSessionListener listener) {
        this.sessionListeners.remove(listener);
    }

    public static synchronized void addHMCSessionLifeListener(HMCSessionLifeListener listener) {
        if (sessionLifeListeners == null) {
            sessionLifeListeners = new ArrayList(3);
        }
        sessionLifeListeners.add(listener);
    }

    public static synchronized void removeHMCSessionLifeListener(HMCSessionLifeListener listener) {
        if (sessionLifeListeners == null) {
            return;
        }
        sessionLifeListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHMCSessionWindowListener(HMCSessionWindowListener listener) {
        Object object = this.windowListenersLock;
        synchronized (object) {
            if (this.windowListeners == null) {
                this.windowListeners = new ArrayList(1);
            }
            this.windowListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHMCSessionWindowListener(HMCSessionWindowListener listener) {
        Object object = this.windowListenersLock;
        synchronized (object) {
            if (this.windowListeners == null) {
                return;
            }
            this.windowListeners = new ArrayList(1);
            this.windowListeners.remove(listener);
        }
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Date getConnectionTime() {
        return this.connectionTime;
    }

    public Date getDisconnectionTime() {
        return this.disconnectionTime;
    }

    public int getDisconnectionReason() {
        return this.disconnectionReason;
    }

    public static String getDisconnectReasonMessageKey(int disconnectionReason) {
        switch (disconnectionReason) {
            case 0: {
                return "DISCONNECT_NOT_DISCONNECTED";
            }
            case 1: {
                return "DISCONNECT_BY_USER";
            }
            case 2: {
                return "DISCONNECT_BY_ANOTHER_USER";
            }
            case 3: {
                return "DISCONNECT_DUE_TO_IDLENESS";
            }
            case 4: {
                return "DISCONNECT_LOSS_OF_CONNECTIVITY";
            }
            case 5: {
                return "DISCONNECT_DIDNT_REAUTHENTICATE_IN_TIME";
            }
            case 6: {
                return "DISCONNECT_REAUTHENTICATION_FAILED";
            }
            case 7: {
                return "DISCONNECT_LOGGING_OFF";
            }
            case 8: {
                return "DISCONNECT_LOGOFF_BY_ANOTHER_USER";
            }
            case 9: {
                return "DISCONNECT_BY_PROXY";
            }
        }
        throw new IllegalArgumentException("Unknown disconnected reason code provided");
    }

    public void setLastUserActivityTime(Date lastUserActivityTime) {
        this.lastUserActivityTime = lastUserActivityTime;
    }

    public Date getLastUserActivityTime() {
        return this.lastUserActivityTime != null ? this.lastUserActivityTime : this.getCreationTime();
    }

    public static void setProcessingReconnect(HttpSession httpSession, boolean processingReconnect) {
        if (processingReconnect) {
            httpSession.setAttribute(PROCESSING_RECONNECT_ATTRIBUTE_IN_HTTP_SESSION, (Object)Boolean.TRUE);
        } else {
            httpSession.removeAttribute(PROCESSING_RECONNECT_ATTRIBUTE_IN_HTTP_SESSION);
        }
    }

    private static boolean isProcessingReconnect(HttpSession httpSession) {
        Boolean flag = (Boolean)httpSession.getAttribute(PROCESSING_RECONNECT_ATTRIBUTE_IN_HTTP_SESSION);
        if (flag == null) {
            return false;
        }
        return flag;
    }

    public static void setRecognitionToken(HttpSession httpSession, String recognitionToken) {
        Trace.trace(TRACE_MASKT, "Setting recognition token \"" + recognitionToken + "\" into HTTP session with id " + httpSession.getId());
        httpSession.setAttribute(RECOGNITION_TOKEN_ATTRIBUTE_IN_HTTP_SESSION, (Object)recognitionToken);
    }

    public static String getRecognitionToken(HttpSession httpSession) {
        return (String)httpSession.getAttribute(RECOGNITION_TOKEN_ATTRIBUTE_IN_HTTP_SESSION);
    }

    protected synchronized void markHttpSessionDefunct() {
        if (this.httpSession == null || HMCSession.isProcessingReconnect(this.httpSession)) {
            return;
        }
        Trace.trace(TRACE_MASKT, "Marking HTTP session with id " + this.httpSession.getId() + " that is associated with HMCSession " + this.sessionId + " as defunct");
        Trace.trace(TRACE_MASKF, "The following task window names will be preserved:");
        ArrayList<String> windowNames = new ArrayList<String>();
        windowNames.add(this.getWindowPrefix() + "hmcuimainwin");
        Iterator iterator = this.taskIdToPanelPortals.values().iterator();
        while (iterator.hasNext()) {
            PanelModelTaskPortal portal = (PanelModelTaskPortal)iterator.next();
            if (portal.isWindowOpen()) {
                windowNames.add(portal.getWindowName());
                Trace.trace(TRACE_MASKF, " name == " + portal.getWindowName());
            }
            Iterator jiterator = portal.getAdditionalWindowNames().iterator();
            while (jiterator.hasNext()) {
                String windowName = (String)jiterator.next();
                Trace.trace(TRACE_MASKF, "  additional name == " + windowName);
                windowNames.add(windowName);
            }
        }
        this.httpSession.setAttribute("util.hmcSessionId", (Object)this.sessionId);
        this.httpSession.setAttribute("util.defunctWindowNames", windowNames);
        this.httpSession.setAttribute("util.timeZone", (Object)this.getUserContext().getTimeZone().getID());
        this.httpSession.setAttribute("util.defunctSession", (Object)"true");
        this.httpSession.setMaxInactiveInterval(3600);
        this.notifyLogoffOrDisconnect(this.httpSession);
        this.httpSession.removeAttribute(RECOGNITION_TOKEN_ATTRIBUTE_IN_HTTP_SESSION);
    }

    public synchronized ServletContext getServletContext() {
        return this.httpSession != null ? this.httpSession.getServletContext() : null;
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    public HMCCustomScope getHMCCustomScope() {
        return this.wclScopeObject;
    }

    public synchronized PanelModelTaskPortal getPanelModelTaskPortal(String taskId) {
        return (PanelModelTaskPortal)this.taskIdToPanelPortals.get(taskId);
    }

    public synchronized void addTask(PanelModelTaskPortal portal) {
        String taskId = portal.getTaskId();
        if (this.isKnownTask(taskId)) {
            throw new IllegalStateException("Task id " + taskId + " is already running.");
        }
        Trace.trace(TRACE_MASKT, "Adding task with id " + taskId + " to HMCSession with id " + this.sessionId);
        this.taskIdToPanelPortals.put(taskId, portal);
        this.fireTaskStartedEvent(portal);
    }

    public synchronized void removeTask(String taskId) {
        if (!this.isKnownTask(taskId)) {
            throw new IllegalStateException("Task id " + taskId + " is not running.");
        }
        Trace.trace(TRACE_MASKT, "Removing task with id " + taskId + " from HMCSession with id " + this.sessionId);
        PanelModelTaskPortal portal = (PanelModelTaskPortal)this.taskIdToPanelPortals.remove(taskId);
        if (portal != null && this.endedTasks.contains(portal)) {
            this.endedTasks.remove(portal);
            this.notifyAll();
        }
    }

    public synchronized boolean isKnownTask(String taskId) {
        return this.taskIdToPanelPortals.containsKey(taskId);
    }

    public synchronized Collection getKnownTasks() {
        return new ArrayList(this.taskIdToPanelPortals.values());
    }

    public synchronized Collection getRunningTasks() {
        Collection tasks = this.getKnownTasks();
        Iterator iterator = tasks.iterator();
        while (iterator.hasNext()) {
            PanelModelTaskPortal portal = (PanelModelTaskPortal)iterator.next();
            if (!portal.isTaskEnded()) continue;
            iterator.remove();
        }
        return tasks;
    }

    public synchronized int getKnownTaskCount() {
        return this.taskIdToPanelPortals.size();
    }

    public synchronized PanelModelTaskPortal getTaskForWindowName(String name) {
        PanelModelTaskPortal portal;
        Iterator iterator = this.getKnownTasks().iterator();
        while (iterator.hasNext()) {
            portal = (PanelModelTaskPortal)iterator.next();
            if (portal.isTaskEnded() || !portal.getWindowName().equals(name)) continue;
            return portal;
        }
        iterator = this.getKnownTasks().iterator();
        while (iterator.hasNext()) {
            portal = (PanelModelTaskPortal)iterator.next();
            if (!portal.getWindowName().equals(name)) continue;
            return portal;
        }
        return null;
    }

    public synchronized void taskEnded(PanelModelTaskPortal task) {
        Trace.trace(TRACE_MASKT, "Task with id " + task.getTaskId() + " has ended in HMCSession with id " + this.sessionId + ".  Leaving as zombie for " + 90000 + " milliseconds");
        task.setAttribute(REAP_TIME_ATTRIBUTE_IN_PORTAL, new Date(System.currentTimeMillis() + 90000L));
        this.endedTasks.add(task);
        if (this.endedTasks.size() == 1) {
            Thread reaper = new Thread(new Runnable(){

                public void run() {
                    HMCSession.this.reapTasks();
                }
            }, "Task reaper for HMC session " + this.sessionId);
            reaper.setDaemon(true);
            reaper.start();
        }
        this.fireTaskEndedEvent(task);
    }

    private synchronized void reapTasks() {
        while (true) {
            PanelModelTaskPortal task;
            long now;
            long reapTime = now = System.currentTimeMillis();
            Iterator iterator = this.endedTasks.iterator();
            while (iterator.hasNext() && now >= (reapTime = ((Date)(task = (PanelModelTaskPortal)iterator.next()).getAttribute(REAP_TIME_ATTRIBUTE_IN_PORTAL)).getTime())) {
                iterator.remove();
                this.removeTask(task.getTaskId());
            }
            if (this.endedTasks.size() == 0) {
                return;
            }
            try {
                this.wait(reapTime - now);
            }
            catch (InterruptedException e) {
            }
        }
    }

    public synchronized Object getSessionAttribute(String name) {
        return this.sessionAttributes.get(name);
    }

    public synchronized Collection getSessionAttributeNames() {
        return new ArrayList(this.sessionAttributes.keySet());
    }

    public synchronized void setSessionAttribute(String name, Object value) {
        this.sessionAttributes.put(name, value);
    }

    public synchronized void removeSessionAttribute(String name) {
        this.sessionAttributes.remove(name);
    }

    public synchronized Object getContextAttribute(String name) {
        return this.contextAttributes.get(name);
    }

    public synchronized Collection getContextAttributeNames() {
        return new ArrayList(this.contextAttributes.keySet());
    }

    public synchronized void setContextAttribute(String name, Object value) {
        this.contextAttributes.put(name, value);
        if (this.httpSession != null) {
            this.httpSession.getServletContext().setAttribute(name, value);
        }
    }

    public synchronized void removeContextAttribute(String name) {
        this.contextAttributes.remove(name);
    }

    public void setAvailableScreenWidth(int width) {
        this.setSessionAttribute("util.availableScreenWidth", new Integer(width));
    }

    public int getAvailableScreenWidth() {
        Integer width = (Integer)this.getSessionAttribute("util.availableScreenWidth");
        if (width == null) {
            return -1;
        }
        return width;
    }

    public void setAvailableScreenHeight(int height) {
        this.setSessionAttribute("util.availableScreenHeight", new Integer(height));
    }

    public int getAvailableScreenHeight() {
        Integer height = (Integer)this.getSessionAttribute("util.availableScreenHeight");
        if (height == null) {
            return -1;
        }
        return height;
    }

    public void setUserInterfaceStyle(UIStyle uiStyle) {
        this.setSessionAttribute("util.uiStyle", uiStyle);
    }

    public UIStyle getUserInterfaceStyle() {
        return (UIStyle)this.getSessionAttribute("util.uiStyle");
    }

    public void destroy() {
        this.destroy(7, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(int reason, boolean launchBrowserCleanup) {
        Trace.trace(TRACE_MASKT, "Destroying HMCSession with id " + this.sessionId + ".  Reason code == " + reason);
        if (this.httpSession != null) {
            this.disconnectFromWebSession(reason, launchBrowserCleanup);
        }
        HMCSession hMCSession = this;
        synchronized (hMCSession) {
            Iterator iterator = this.taskIdToPanelPortals.values().iterator();
            while (iterator.hasNext()) {
                PanelModelTaskPortal portal = (PanelModelTaskPortal)iterator.next();
                if (portal.isTaskEnded()) continue;
                portal.getPresentationTask().forceTaskToTerminate("HMCSession is being destroyed");
            }
            this.listener.sessionIsDestroyed();
            this.fireSessionDestroyedEvent();
            HMCSession.removeDisconnectedSession(this);
            HMCSession.removeSession(this);
        }
        TaskControllerQueue.getTaskControllerQueue(this).removeTaskControllerListener(this.listener);
    }

    public synchronized boolean haveConnectivity() {
        return this.lossOfConnectivityTime == null;
    }

    public synchronized Date getLossOfConnectivityTime() {
        return this.lossOfConnectivityTime;
    }

    public synchronized void taskIsRealized(PanelModelTaskPortal task) {
        this.fireTaskRealizedEvent(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openingMainUIWindow() {
        HMCSession hMCSession = this;
        synchronized (hMCSession) {
            this.userClosedMainUIWindowTime = null;
        }
        ActivityManager.getActivityManager().reexamine(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userClosedMainUIWindow() {
        HMCSession hMCSession = this;
        synchronized (hMCSession) {
            this.userClosedMainUIWindowTime = new Date();
        }
        this.fireWindowClosedEvent(null, this.getWindowPrefix() + "hmcuimainwin");
    }

    public synchronized Date getUserClosedMainUIWindowTime() {
        return this.userClosedMainUIWindowTime;
    }

    private synchronized void processConnectivityAcquired() {
        this.lossOfConnectivityTime = null;
        Trace.trace(TRACE_MASKT, "Gained connectivity on HMCSession with id " + this.sessionId);
        this.fireConnectivityGainedEvent();
    }

    private synchronized void processConnectivityLost(Throwable e) {
        this.lossOfConnectivityTime = new Date();
        if (e == null) {
            Trace.trace(TRACE_MASKT, "Lost connectivity on HMCSession with id " + this.sessionId + " for unknown reason");
        } else {
            Trace.trace(TRACE_MASKT, "Lost connectivity on HMCSession with id " + this.sessionId + " due to exception " + e);
        }
        this.fireConnectivityLostEvent();
    }

    private static void fireSessionCreatedEvent(HMCSession session) {
        if (sessionLifeListeners == null) {
            return;
        }
        Iterator iterator = new ArrayList(sessionLifeListeners).iterator();
        while (iterator.hasNext()) {
            HMCSessionLifeListener listener = (HMCSessionLifeListener)iterator.next();
            try {
                listener.sessionCreated(session);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(TRACE_MASKF, "Ignoring exception from sessionCreated() event handler:");
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }

    private static void fireSessionRemovedEvent(HMCSession session) {
        if (sessionLifeListeners == null) {
            return;
        }
        Iterator iterator = new ArrayList(sessionLifeListeners).iterator();
        while (iterator.hasNext()) {
            HMCSessionLifeListener listener = (HMCSessionLifeListener)iterator.next();
            try {
                listener.sessionRemoved(session);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(TRACE_MASKF, "Ignoring exception from sessionRemoved() event handler:");
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }

    private void fireSessionConnectedEvent() {
        Iterator iterator = new ArrayList(this.sessionListeners).iterator();
        while (iterator.hasNext()) {
            HMCSessionListener listener = (HMCSessionListener)iterator.next();
            try {
                listener.sessionConnected(this);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(TRACE_MASKF, "Ignoring exception from sessionConnected() event handler:");
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }

    private synchronized void fireSessionDisconnectedEvent() {
        Iterator iterator = new ArrayList(this.sessionListeners).iterator();
        while (iterator.hasNext()) {
            HMCSessionListener listener = (HMCSessionListener)iterator.next();
            try {
                listener.sessionDisconnected(this);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(TRACE_MASKF, "Ignoring exception from sessionDisconnected() event handler:");
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }

    private synchronized void fireSessionDestroyedEvent() {
        Iterator iterator = new ArrayList(this.sessionListeners).iterator();
        while (iterator.hasNext()) {
            HMCSessionListener listener = (HMCSessionListener)iterator.next();
            try {
                listener.sessionDestroyed(this);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(TRACE_MASKF, "Ignoring exception from sessionDestroyed() event handler:");
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }

    private void fireConnectivityLostEvent() {
        Iterator iterator = new ArrayList(this.sessionListeners).iterator();
        while (iterator.hasNext()) {
            HMCSessionListener listener = (HMCSessionListener)iterator.next();
            try {
                listener.clientConnectivityLost(this);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(TRACE_MASKF, "Ignoring exception from clientConnectivityLost() event handler:");
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }

    private void fireConnectivityGainedEvent() {
        Iterator iterator = new ArrayList(this.sessionListeners).iterator();
        while (iterator.hasNext()) {
            HMCSessionListener listener = (HMCSessionListener)iterator.next();
            try {
                listener.clientConnectivityGained(this);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(TRACE_MASKF, "Ignoring exception from clientConnectivityGained() event handler:");
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }

    private void fireTaskStartedEvent(PanelModelTaskPortal task) {
        Iterator iterator = new ArrayList(this.sessionListeners).iterator();
        while (iterator.hasNext()) {
            HMCSessionListener listener = (HMCSessionListener)iterator.next();
            try {
                listener.taskStarted(this, task);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(TRACE_MASKF, "Ignoring exception from taskStarted() event handler:");
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }

    private void fireTaskEndedEvent(PanelModelTaskPortal task) {
        Iterator iterator = new ArrayList(this.sessionListeners).iterator();
        while (iterator.hasNext()) {
            HMCSessionListener listener = (HMCSessionListener)iterator.next();
            try {
                listener.taskEnded(this, task);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(TRACE_MASKF, "Ignoring exception from taskEnded() event handler:");
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }

    private void fireTaskRealizedEvent(PanelModelTaskPortal task) {
        Iterator iterator = new ArrayList(this.sessionListeners).iterator();
        while (iterator.hasNext()) {
            HMCSessionListener listener = (HMCSessionListener)iterator.next();
            try {
                listener.taskRealized(this, task);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(TRACE_MASKF, "Ignoring exception from taskRealized() event handler:");
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }

    private void notifyLogoffOrDisconnect(HttpSession httpSession) {
        String recognitionToken = HMCSession.getRecognitionToken(httpSession);
        if (recognitionToken == null) {
            return;
        }
        autoLogonInterface.loggedOffOrDisconnected(recognitionToken, this);
    }

    private void notifyAssociatingWithHMCSession(HttpSession httpSession) {
        String recognitionToken = HMCSession.getRecognitionToken(httpSession);
        if (recognitionToken == null) {
            return;
        }
        autoLogonInterface.associatingWithHMCSession(recognitionToken, this);
    }

    private void notifyDisassociatingFromHMCSession(HttpSession httpSession) {
        String recognitionToken = HMCSession.getRecognitionToken(httpSession);
        if (recognitionToken == null) {
            return;
        }
        autoLogonInterface.disassociatingFromHMCSession(recognitionToken, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireWindowOpenedEvent(PanelModelTaskPortal task, String windowName) {
        Object object = this.windowListenersLock;
        synchronized (object) {
            if (this.windowListeners == null || this.windowListeners.isEmpty()) {
                return;
            }
            Iterator iterator = new ArrayList(this.windowListeners).iterator();
            while (iterator.hasNext()) {
                HMCSessionWindowListener listener = (HMCSessionWindowListener)iterator.next();
                try {
                    listener.windowOpened(this, task, windowName);
                }
                catch (Throwable e) {
                    if (e instanceof ThreadDeath) {
                        throw (ThreadDeath)e;
                    }
                    Trace.trace(TRACE_MASKF, "Ignoring exception from windowOpened() event handler:");
                    Trace.trace(TRACE_MASKF, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireWindowClosedEvent(PanelModelTaskPortal task, String windowName) {
        Object object = this.windowListenersLock;
        synchronized (object) {
            if (this.windowListeners == null || this.windowListeners.isEmpty()) {
                return;
            }
            Iterator iterator = new ArrayList(this.windowListeners).iterator();
            while (iterator.hasNext()) {
                HMCSessionWindowListener listener = (HMCSessionWindowListener)iterator.next();
                try {
                    listener.windowClosed(this, task, windowName);
                }
                catch (Throwable e) {
                    if (e instanceof ThreadDeath) {
                        throw (ThreadDeath)e;
                    }
                    Trace.trace(TRACE_MASKF, "Ignoring exception from windowClosed() event handler:");
                    Trace.trace(TRACE_MASKF, e);
                }
            }
        }
    }

    static {
        allSessions = new ArrayList();
        autoLogonInterface = AutoLogonManager.getAutoLogonManager().getAutoLogonInterface();
    }

    private class Listener
    implements TaskControllerListener {
        boolean sessionDestroyed;

        private Listener() {
        }

        public void taskControllerConnected(HMCSession session) {
            if (this.sessionDestroyed) {
                return;
            }
            HMCSession.this.processConnectivityAcquired();
        }

        public void taskControllerDisconnected(HMCSession session, Throwable e) {
            if (this.sessionDestroyed) {
                return;
            }
            HMCSession.this.processConnectivityLost(e);
        }

        void sessionIsDestroyed() {
            this.sessionDestroyed = true;
        }
    }
}

